﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using DataAccess;

/// <summary>
/// Treatment methods and properties
/// </summary>
public class CTreatment
{
    /// <summary>
    /// Default constructor
    /// </summary>
	public CTreatment()
	{
		
	}

    /// <summary>
    /// get a dataset of patients encounters
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetTreatmentListDS( BaseMaster BaseMstr,
                                       string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
       
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_TREATMENT.GetTreatmentListRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }

    }

    /// <summary>
    /// Get record list dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lnLookupSearchCase"></param>
    /// <returns></returns>
    public DataSet GetRecordList(BaseMaster BaseMstr,
                                 string strPatientID,
                                 long lnLookupSearchCase)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from BaseMstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nSelectCases", lnLookupSearchCase);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_TREATMENT.GetTreatmentsList",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// Get modality dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lModalityID"></param>
    /// <returns></returns>
    public DataSet GetStatModalityByModalityIDDS(BaseMaster BaseMstr,
                                         long lModalityID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from BaseMstr
        CDataParameterList pList = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //add params for the DB stored procedure call
        pList.AddInputParameter("pi_nModalityID", lModalityID);

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_TREATMENT.GetStatModalityByModalityIDRS",
                                            pList,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode != 0)
        {
            return null;
        }

        return ds;
    }

    /// <summary>
    /// Get stat modality entries by encounter type
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetAllStatModalityTypesDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID, BaseMstr.ClientIP, BaseMstr.FXUserID);

        //get and return a dataset

        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_TREATMENT.GetAllStatModalityTypesRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);

        //set the base master status code and status for display
        BaseMstr.StatusCode = lStatusCode;
        BaseMstr.StatusComment = strStatusComment;

        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

}
